import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/model/invoice/invoice_list_response_model.dart';
import 'package:viserpay/view/components/card/account_details_card.dart';
import 'package:viserpay/view/components/card/cash_2colum.dart';
import 'package:viserpay/view/components/cash-card/title_card.dart';
import 'package:viserpay/view/components/cash-card/user/user_card.dart';
import 'package:viserpay/view/components/dialog/app_dialog.dart';
import 'package:viserpay/view/components/snack_bar/show_custom_snackbar.dart';
import 'package:viserpay/view/components/text-form-field/customPinText.dart';

import '../../../../core/helper/string_format_helper.dart';
import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';
import '../../../../data/controller/invoice/invoice_history_controller.dart';
import '../../../../data/repo/invoice/invoice_repo.dart';
import '../../../../data/services/api_service.dart';
import '../../../components/app-bar/custom_appbar.dart';
import '../../../components/custom_loader/custom_loader.dart';

class InvoiceDetailsScreen extends StatefulWidget {
  const InvoiceDetailsScreen({super.key, this.invoicesDataModel});
  final InvoiceDataModel? invoicesDataModel;

  @override
  State<InvoiceDetailsScreen> createState() => _InvoiceDetailsScreenState();
}

class _InvoiceDetailsScreenState extends State<InvoiceDetailsScreen> {
  // final ScrollController scrollController = ScrollController();

  // void scrollListener() {
  //   if (scrollController.position.pixels == scrollController.position.maxScrollExtent) {
  //     if (Get.find<InvoiceHistoryController>().hasNext()) {
  //       Get.find<InvoiceHistoryController>().loadInvoiceData();
  //     }
  //   }
  // }

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(InvoiceRepo(apiClient: Get.find()));
    final controller = Get.put(InvoiceHistoryController(invoiceHistoryRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      // controller.initialData();
      controller.changeInfoWidget(widget.invoicesDataModel?.totalAmount ?? "0");
    });
  }

  @override
  void dispose() {
    super.dispose();
    cleanData();
  }

  cleanData() {
    Get.find<InvoiceHistoryController>().pinController.text = "";
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: MyColor.colorWhite,
      appBar: CustomAppBar(
        title: MyStrings.invoicePayment,
        isTitleCenter: true,
        elevation: 0.1,
      ),
      body: GetBuilder<InvoiceHistoryController>(builder: (controller) {
        return controller.isLoading
            ? const CustomLoader()
            : SingleChildScrollView(
                physics: const BouncingScrollPhysics(),
                padding: EdgeInsets.zero,
                child: Padding(
                  padding: Dimensions.defaultPaddingHV,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      TitleCard(
                        title: "${MyStrings.merchant.tr} ",
                        onlyBottom: true,
                        widget: Padding(
                          padding: const EdgeInsets.all(10.0),
                          child: UserCard(title: widget.invoicesDataModel?.merchant?.username ?? "", subtitle: "+${widget.invoicesDataModel?.merchant?.mobile ?? ""}"),
                        ),
                      ),
                      const SizedBox(
                        height: Dimensions.space16,
                      ),
                      AccountDetailsCard(
                        amount: controller.currencySym + controller.mainAmount.toString(),
                        charge: controller.currencySym + controller.charge,
                        total: controller.currencySym + controller.payableText.toString(),
                      ),
                      const SizedBox(
                        height: Dimensions.space20,
                      ),
                      controller.otpTypeList.isNotEmpty ? Text(MyStrings.selectOtpType.tr, style: mediumDefault.copyWith()) : const SizedBox.shrink(),
                      controller.otpTypeList.isNotEmpty
                          ? SingleChildScrollView(
                              physics: const BouncingScrollPhysics(),
                              scrollDirection: Axis.horizontal,
                              padding: EdgeInsets.zero,
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: List.generate(
                                  controller.otpTypeList.length,
                                  (index) => Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    children: [
                                      Row(
                                        children: [
                                          Checkbox(
                                            value: controller.selectedOtpType == controller.otpTypeList[index] ? true : false,
                                            onChanged: (p) {
                                              controller.selectOtpType(controller.otpTypeList[index]);
                                            },
                                            shape: const CircleBorder(),
                                            activeColor: MyColor.primaryDark,
                                          ),
                                          GestureDetector(
                                            onTap: () {
                                              controller.selectOtpType(controller.otpTypeList[index]);
                                            },
                                            child: Text(
                                              controller.otpTypeList[index].toUpperCase(),
                                              style: semiBoldDefault.copyWith(
                                                color: controller.selectedOtpType.toLowerCase() == controller.otpTypeList[index].toLowerCase() ? MyColor.colorBlack : MyColor.primaryDark,
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            )
                          : const SizedBox.shrink(),
                      CustomPinField(
                        onChanged: (p) {
                          MyUtils.vibrate();
                        },
                        controller: controller.pinController,
                        focusNode: controller.pinFocusNode,
                        needOutlineBorder: true,
                        labelText: "",
                        hintText: MyStrings.enterYourPIN,
                        isShowSuffixIcon: true,
                        textInputType: TextInputType.number,
                        inputAction: TextInputAction.done,
                        prefixIcon: const SizedBox(
                          width: 22,
                          height: 22,
                          child: Padding(
                            padding: EdgeInsets.all(8.0),
                            child: Icon(
                              Icons.lock,
                              color: MyColor.primaryColor,
                            ),
                          ),
                        ),
                        suffixWidget: GestureDetector(
                          onTap: () {
                            String newBalance = StringConverter.minus(controller.currentBalance, controller.payableText);
                            if (controller.otpTypeList.isEmpty) {
                              if (controller.validatePinCode()) {
                                submitDialog(context, controller, newBalance);
                              }
                            } else {
                              if (controller.validatePinCode() == true) {
                                if (controller.selectedOtpType == 'null') {
                                  CustomSnackBar.error(errorList: [MyStrings.pleaseSelectOtp.tr]);
                                } else {
                                  submitDialog(context, controller, newBalance);
                                }
                              }
                            }
                          },
                          child: const SizedBox(
                            width: 22,
                            height: 22,
                            child: Padding(
                              padding: EdgeInsets.all(5.0),
                              child: Icon(
                                Icons.arrow_right_alt_sharp,
                                color: MyColor.primaryColor,
                              ),
                            ),
                          ),
                        ),
                        onSubmit: () {
                          String newBalance = StringConverter.minus(controller.currentBalance, controller.payableText);
                          if (controller.otpTypeList.isEmpty) {
                            if (controller.validatePinCode()) {
                              submitDialog(context, controller, newBalance);
                            }
                          } else {
                            if (controller.validatePinCode() == true) {
                              if (controller.selectedOtpType == 'null') {
                                CustomSnackBar.error(errorList: [MyStrings.pleaseSelectOtp.tr]);
                              } else {
                                submitDialog(context, controller, newBalance);
                              }
                            }
                          }
                        },
                      ),
                    ],
                  ),
                ),
              );
      }),
    );
  }

  void submitDialog(BuildContext context, InvoiceHistoryController controller, String newBalance) {
    AppDialog().confirmDialog(
      context,
      title: MyStrings.invoicePayment.tr,
      userDetails: UserCard(
        title: widget.invoicesDataModel?.merchant?.username ?? "",
        subtitle: "+${widget.invoicesDataModel?.merchant?.mobile ?? ""}",
      ),
      cashDetails: CashDetailsColumn(
        total: controller.currencySym + controller.payableText,
        newBalance: controller.currencySym + newBalance,
        charge: MyUtils.getChargeText("${controller.currencySym}${controller.charge}"),
      ),
      onFinish: () {},
      onWaiting: () {
        // controller.submitSendMoney();

        controller.submitMakePayment(invoiceID: widget.invoicesDataModel?.id.toString() ?? "-1");
      },
    );
  }
}
